/*
 * Decompiled with CFR 0.152.
 */
package v2.io.swagger.models.refs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import v2.io.swagger.models.refs.RefFormat;
import v2.io.swagger.models.refs.RefType;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class GenericRef {
    private RefFormat format;
    private RefType type;
    private String ref;
    private String simpleRef;
    static final long serialVersionUID = 1079497836976849938L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public GenericRef() {
    }

    public GenericRef(RefType type, String ref) {
        this.format = GenericRef.computeRefFormat(ref);
        this.type = type;
        this.ref = this.format == RefFormat.INTERNAL && !ref.startsWith("#/") ? type.getInternalPrefix() + ref : ref;
        this.simpleRef = GenericRef.computeSimpleRef(this.ref, this.format, type);
    }

    public RefFormat getFormat() {
        return this.format;
    }

    public RefType getType() {
        return this.type;
    }

    public String getRef() {
        return this.ref;
    }

    public String getSimpleRef() {
        return this.simpleRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericRef)) {
            return false;
        }
        GenericRef that = (GenericRef)o;
        if (this.format != that.format) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (this.ref != null ? !this.ref.equals(that.ref) : that.ref != null) {
            return false;
        }
        return this.simpleRef != null ? this.simpleRef.equals(that.simpleRef) : that.simpleRef == null;
    }

    public int hashCode() {
        int result = this.format != null ? this.format.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.ref != null ? this.ref.hashCode() : 0);
        result = 31 * result + (this.simpleRef != null ? this.simpleRef.hashCode() : 0);
        return result;
    }

    private static String computeSimpleRef(String ref, RefFormat format, RefType type) {
        String prefix;
        String result = ref;
        if (format == RefFormat.INTERNAL && ref.startsWith(prefix = type.getInternalPrefix())) {
            result = ref.substring(prefix.length());
        }
        return result;
    }

    private static RefFormat computeRefFormat(String ref) {
        RefFormat result = RefFormat.INTERNAL;
        if (ref.startsWith("http:") || ref.startsWith("https:")) {
            result = RefFormat.URL;
        } else if (ref.startsWith("#/")) {
            result = RefFormat.INTERNAL;
        } else if (ref.startsWith(".") || ref.startsWith("/")) {
            result = RefFormat.RELATIVE;
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"v2.io.swagger.models.refs.GenericRef", GenericRef.class, null, null);
    }
}

