/*
 * Decompiled with CFR 0.152.
 */
package v2.io.swagger.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import v2.io.swagger.models.ExternalDocs;
import v2.io.swagger.models.Info;
import v2.io.swagger.models.Model;
import v2.io.swagger.models.Operation;
import v2.io.swagger.models.Path;
import v2.io.swagger.models.Paths;
import v2.io.swagger.models.Response;
import v2.io.swagger.models.Responses;
import v2.io.swagger.models.Scheme;
import v2.io.swagger.models.SecurityRequirement;
import v2.io.swagger.models.SwaggerException;
import v2.io.swagger.models.Tag;
import v2.io.swagger.models.auth.SecuritySchemeDefinition;
import v2.io.swagger.models.parameters.Parameter;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Swagger {
    private static final TraceComponent tc = Tr.register(Swagger.class, (String)"SwaggerModels", (String)"v2.io.swagger.models.internal.resources.SwaggerModelsMessages");
    private static final Set<String> RESERVED_VENDOR_EXTENSION = new HashSet<String>(Arrays.asList("x-ibm-httpPort", "x-ibm-httpsPort", "x-ibm-services"));
    protected String swagger = "2.0";
    protected Info info;
    protected String host;
    protected String basePath;
    protected List<Tag> tags;
    protected List<Scheme> schemes;
    protected List<String> consumes;
    protected List<String> produces;
    protected List<SecurityRequirement> security;
    protected Paths paths;
    protected Map<String, SecuritySchemeDefinition> securityDefinitions;
    protected Map<String, Model> definitions;
    protected Map<String, Parameter> parameters;
    protected Responses responses;
    protected ExternalDocs externalDocs;
    protected Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();
    static final long serialVersionUID = -7647336183135533699L;

    public Swagger info(Info info) {
        this.setInfo(info);
        return this;
    }

    public Swagger host(String host) {
        this.setHost(host);
        return this;
    }

    public Swagger basePath(String basePath) {
        this.setBasePath(basePath);
        return this;
    }

    public Swagger externalDocs(ExternalDocs value) {
        this.setExternalDocs(value);
        return this;
    }

    public Swagger tags(List<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public Swagger tag(Tag tag) {
        this.addTag(tag);
        return this;
    }

    public Swagger schemes(List<Scheme> schemes) {
        this.setSchemes(schemes);
        return this;
    }

    public Swagger scheme(Scheme scheme) {
        this.addScheme(scheme);
        return this;
    }

    public Swagger consumes(List<String> consumes) {
        this.setConsumes(consumes);
        return this;
    }

    public Swagger consumes(String consumes) {
        this.addConsumes(consumes);
        return this;
    }

    public Swagger produces(List<String> produces) {
        this.setProduces(produces);
        return this;
    }

    public Swagger produces(String produces) {
        this.addProduces(produces);
        return this;
    }

    public Swagger paths(Map<String, Path> paths) {
        this.setPaths(paths);
        return this;
    }

    public Swagger path(String key, Path path) {
        if (this.paths == null) {
            this.paths = new Paths();
        }
        this.paths.setPath(key, path);
        return this;
    }

    public Swagger responses(Map<String, Response> responses) {
        this.setResponses(responses);
        return this;
    }

    public Swagger response(String key, Response response) {
        this.addResponse(key, response);
        return this;
    }

    public Swagger parameter(String key, Parameter parameter) {
        this.addParameter(key, parameter);
        return this;
    }

    public Swagger securityDefinition(String name, SecuritySchemeDefinition securityDefinition) {
        this.addSecurityDefinition(name, securityDefinition);
        return this;
    }

    public Swagger model(String name, Model model) {
        this.addDefinition(name, model);
        return this;
    }

    public Swagger security(SecurityRequirement securityRequirement) {
        this.addSecurity(securityRequirement);
        return this;
    }

    public Swagger vendorExtension(String key, Object extension) {
        if (this.vendorExtensions == null) {
            this.vendorExtensions = new LinkedHashMap<String, Object>();
        }
        this.vendorExtensions.put(key, extension);
        return this;
    }

    public String getSwagger() {
        return this.swagger;
    }

    public void setSwagger(String swagger) {
        this.swagger = swagger;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public List<Scheme> getSchemes() {
        return this.schemes;
    }

    public void setSchemes(List<Scheme> schemes) {
        this.schemes = schemes;
    }

    public void addScheme(Scheme scheme) {
        if (this.schemes == null) {
            this.schemes = new ArrayList<Scheme>();
        }
        if (!this.schemes.contains((Object)scheme)) {
            this.schemes.add(scheme);
        }
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        if (tags != null) {
            ArrayList<String> tagNames = new ArrayList<String>();
            for (Tag tag : tags) {
                String tagName;
                if (tag == null || (tagName = tag.getName()) == null) continue;
                if (tagNames.contains(tagName)) {
                    throw new SwaggerException(Tr.formatMessage((TraceComponent)tc, (String)"INVALID_TAG", (Object[])new Object[]{tagName}));
                }
                tagNames.add(tagName);
            }
        }
        this.tags = tags;
    }

    public void addTag(Tag tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        if (tag != null && tag.getName() != null) {
            boolean found = false;
            for (Tag existing : this.tags) {
                if (!existing.getName().equals(tag.getName())) continue;
                throw new SwaggerException(Tr.formatMessage((TraceComponent)tc, (String)"INVALID_TAG", (Object[])new Object[]{tag.getName()}));
            }
            if (!found) {
                this.tags.add(tag);
            }
        }
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void addConsumes(String consumes) {
        if (this.consumes == null) {
            this.consumes = new ArrayList<String>();
        }
        if (!this.consumes.contains(consumes)) {
            this.consumes.add(consumes);
        }
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void addProduces(String produces) {
        if (this.produces == null) {
            this.produces = new ArrayList<String>();
        }
        if (!this.produces.contains(produces)) {
            this.produces.add(produces);
        }
    }

    @JsonIgnore
    public Map<String, Path> getPaths() {
        if (this.paths == null) {
            return null;
        }
        return this.paths.getSortedPaths();
    }

    @JsonIgnore
    public void setPaths(Map<String, Path> paths) {
        if (this.paths == null) {
            this.paths = new Paths();
        }
        this.paths.setPaths(paths);
    }

    @JsonProperty(value="paths")
    public void setPathsObject(Paths paths) {
        this.paths = paths;
    }

    @JsonProperty(value="paths")
    public Paths getPathsObject() {
        return this.paths;
    }

    public Path getPath(String path) {
        if (this.paths == null) {
            return null;
        }
        return this.paths.getPath(path);
    }

    public Map<String, SecuritySchemeDefinition> getSecurityDefinitions() {
        return this.securityDefinitions;
    }

    public void setSecurityDefinitions(Map<String, SecuritySchemeDefinition> securityDefinitions) {
        this.securityDefinitions = securityDefinitions;
    }

    public void addSecurityDefinition(String name, SecuritySchemeDefinition securityDefinition) {
        if (this.securityDefinitions == null) {
            this.securityDefinitions = new LinkedHashMap<String, SecuritySchemeDefinition>();
        }
        this.securityDefinitions.put(name, securityDefinition);
    }

    @JsonIgnore
    @Deprecated
    public List<SecurityRequirement> getSecurityRequirement() {
        return this.security;
    }

    @JsonIgnore
    @Deprecated
    public void setSecurityRequirement(List<SecurityRequirement> securityRequirements) {
        this.security = securityRequirements;
    }

    @JsonIgnore
    @Deprecated
    public void addSecurityDefinition(SecurityRequirement securityRequirement) {
        this.addSecurity(securityRequirement);
    }

    public List<SecurityRequirement> getSecurity() {
        return this.security;
    }

    public void setSecurity(List<SecurityRequirement> securityRequirements) {
        this.security = securityRequirements;
    }

    public void addSecurity(SecurityRequirement securityRequirement) {
        if (this.security == null) {
            this.security = new ArrayList<SecurityRequirement>();
        }
        this.security.add(securityRequirement);
    }

    public Map<String, Model> getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(Map<String, Model> definitions) {
        this.definitions = definitions;
    }

    public void addDefinition(String key, Model model) {
        if (this.definitions == null) {
            this.definitions = new LinkedHashMap<String, Model>();
        }
        this.definitions.put(key, model);
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Parameter> parameters) {
        this.parameters = parameters;
    }

    public Parameter getParameter(String parameter) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(parameter);
    }

    public void addParameter(String key, Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, Parameter>();
        }
        this.parameters.put(key, parameter);
    }

    @JsonIgnore
    public Map<String, Response> getResponses() {
        if (this.responses == null) {
            return null;
        }
        return this.responses.getResponses();
    }

    @JsonIgnore
    public void setResponses(Map<String, Response> responses) {
        if (this.responses == null) {
            this.responses = new Responses();
        }
        this.responses.setResponses(responses);
    }

    @JsonProperty(value="responses")
    public Responses getResponsesObject() {
        return this.responses;
    }

    @JsonProperty(value="responses")
    public void setResponsesObject(Responses responses) {
        this.responses = responses;
    }

    public Response getResponse(String response) {
        if (this.responses == null) {
            return null;
        }
        return this.responses.getResponse(response);
    }

    public void addResponse(String key, Response response) {
        if (this.responses == null) {
            this.responses = new Responses();
        }
        this.responses.addResponse(key, response);
    }

    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocs value) {
        this.externalDocs = value;
    }

    @JsonAnyGetter
    public Map<String, Object> getVendorExtensions() {
        return this.vendorExtensions;
    }

    @JsonAnySetter
    public void setVendorExtension(String name, Object value) {
        if (name.startsWith("x-")) {
            this.vendorExtension(name, value);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.basePath == null ? 0 : this.basePath.hashCode());
        result = 31 * result + (this.consumes == null ? 0 : this.consumes.hashCode());
        result = 31 * result + (this.definitions == null ? 0 : this.definitions.hashCode());
        result = 31 * result + (this.externalDocs == null ? 0 : this.externalDocs.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.paths == null ? 0 : this.paths.hashCode());
        result = 31 * result + (this.produces == null ? 0 : this.produces.hashCode());
        result = 31 * result + (this.responses == null ? 0 : this.responses.hashCode());
        result = 31 * result + (this.schemes == null ? 0 : this.schemes.hashCode());
        result = 31 * result + (this.security == null ? 0 : this.security.hashCode());
        result = 31 * result + (this.securityDefinitions == null ? 0 : this.securityDefinitions.hashCode());
        result = 31 * result + (this.swagger == null ? 0 : this.swagger.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.vendorExtensions == null ? 0 : this.vendorExtensions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Swagger other = (Swagger)obj;
        if (this.basePath == null ? other.basePath != null : !this.basePath.equals(other.basePath)) {
            return false;
        }
        if (this.consumes == null ? other.consumes != null : !this.consumes.equals(other.consumes)) {
            return false;
        }
        if (this.definitions == null ? other.definitions != null : !this.definitions.equals(other.definitions)) {
            return false;
        }
        if (this.externalDocs == null ? other.externalDocs != null : !this.externalDocs.equals(other.externalDocs)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.info == null ? other.info != null : !this.info.equals(other.info)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        if (this.paths == null ? other.paths != null : !this.paths.equals(other.paths)) {
            return false;
        }
        if (this.produces == null ? other.produces != null : !this.produces.equals(other.produces)) {
            return false;
        }
        if (this.responses == null ? other.responses != null : !this.responses.equals(other.responses)) {
            return false;
        }
        if (this.schemes == null ? other.schemes != null : !this.schemes.equals(other.schemes)) {
            return false;
        }
        if (this.security == null ? other.security != null : !this.security.equals(other.security)) {
            return false;
        }
        if (this.securityDefinitions == null ? other.securityDefinitions != null : !this.securityDefinitions.equals(other.securityDefinitions)) {
            return false;
        }
        if (this.swagger == null ? other.swagger != null : !this.swagger.equals(other.swagger)) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        return !(this.vendorExtensions == null ? other.vendorExtensions != null : !this.vendorExtensions.equals(other.vendorExtensions));
    }

    public Swagger vendorExtensions(Map<String, Object> vendorExtensions) {
        if (vendorExtensions == null) {
            return this;
        }
        if (this.vendorExtensions == null) {
            this.vendorExtensions = new LinkedHashMap<String, Object>();
        }
        this.vendorExtensions.putAll(vendorExtensions);
        return this;
    }

    public void setVendorExtensions(Map<String, Object> vendorExtensions) {
        if (vendorExtensions != null) {
            this.vendorExtensions = vendorExtensions;
        }
    }

    public void handleGlobalProperties() {
        if (this.paths == null || this.paths.getPaths().isEmpty()) {
            this.removeGlobalProperties();
            return;
        }
        for (String pathKey : this.paths.getPaths().keySet()) {
            Path path = this.paths.getPath(pathKey);
            if (path == null || path.getOperations() == null) continue;
            for (Operation opr : path.getOperations()) {
                if (opr == null) continue;
                this.addGlobalPropertiesToOperation(opr);
            }
        }
        this.removeGlobalProperties();
    }

    private void addGlobalPropertiesToOperation(Operation opr) {
        if (opr == null) {
            return;
        }
        if (this.schemes != null && !this.schemes.isEmpty() && (opr.getSchemes() == null || opr.getSchemes().isEmpty())) {
            opr.setSchemes(this.schemes);
        }
        if (this.consumes != null && !this.consumes.isEmpty() && opr.getConsumes() == null) {
            opr.setConsumes(this.consumes);
        }
        if (this.produces != null && !this.produces.isEmpty() && opr.getProduces() == null) {
            opr.setProduces(this.produces);
        }
        if (this.security != null && !this.security.isEmpty() && opr.getSecurity() == null) {
            ArrayList<Map<String, List<String>>> tempList = new ArrayList<Map<String, List<String>>>();
            for (SecurityRequirement sec : this.security) {
                if (sec.getRequirements() == null) continue;
                tempList.add(sec.getRequirements());
            }
            opr.setSecurity(tempList);
        }
    }

    private void removeGlobalProperties() {
        this.consumes = null;
        this.produces = null;
        this.schemes = null;
        this.security = null;
    }

    public Map<String, Set<String>> gatherNamesAlreadyTaken() {
        HashMap<String, Set<String>> names = new HashMap<String, Set<String>>();
        if (this.definitions != null && !this.definitions.isEmpty()) {
            names.put("definitions", this.definitions.keySet());
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            names.put("parameters", this.parameters.keySet());
        }
        if (this.securityDefinitions != null && !this.securityDefinitions.isEmpty()) {
            names.put("securityDefinitions", this.securityDefinitions.keySet());
        }
        if (this.responses != null && !this.responses.getResponses().isEmpty()) {
            names.put("responses", this.responses.getResponses().keySet());
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            names.put("tags", this.gatherTagNames());
        }
        if (this.paths != null && !this.paths.getPaths().isEmpty()) {
            HashSet<String> operationIDs = new HashSet<String>();
            for (String pathName : this.paths.getPaths().keySet()) {
                Path aPath = this.paths.getPath(pathName);
                if (aPath == null || aPath.getOperations() == null) continue;
                for (Operation operation : aPath.getOperations()) {
                    if (operation == null || operation.getOperationId() == null) continue;
                    operationIDs.add(operation.getOperationId());
                }
            }
            names.put("operationId", operationIDs);
        }
        return names;
    }

    public Map<String, Set<String>> mergeSwagger(Swagger incomingDoc) {
        List<Tag> tagsToAdd;
        Map<String, Response> respToAdd;
        Map<String, SecuritySchemeDefinition> secToAdd;
        Map<String, Path> pathsToAdd;
        Map<String, Parameter> paramToAdd;
        Map<String, Model> defToAdd;
        String key2;
        Iterator<String> itr;
        HashMap<String, Set<String>> addedItems = new HashMap<String, Set<String>>();
        if (incomingDoc == null) {
            return addedItems;
        }
        Map<String, Object> vExtensions = incomingDoc.getVendorExtensions();
        if (vExtensions != null && !vExtensions.isEmpty()) {
            itr = vExtensions.keySet().iterator();
            HashSet<String> addedKeys = new HashSet<String>();
            while (itr.hasNext()) {
                key2 = itr.next();
                if (RESERVED_VENDOR_EXTENSION.contains(key2)) continue;
                this.setVendorExtension(key2, vExtensions.get(key2));
                addedKeys.add(key2);
            }
            addedItems.put("swvendorext", addedKeys);
        }
        if ((defToAdd = incomingDoc.getDefinitions()) != null && !defToAdd.isEmpty()) {
            itr = defToAdd.keySet().iterator();
            HashSet<String> addedKeys = new HashSet<String>();
            while (itr.hasNext()) {
                key2 = itr.next();
                this.addDefinition(key2, defToAdd.get(key2));
                addedKeys.add(key2);
            }
            addedItems.put("definitions", addedKeys);
        }
        if ((paramToAdd = incomingDoc.getParameters()) != null && !paramToAdd.isEmpty()) {
            itr = paramToAdd.keySet().iterator();
            HashSet<String> addedKeys = new HashSet<String>();
            while (itr.hasNext()) {
                key2 = itr.next();
                this.addParameter(key2, paramToAdd.get(key2));
                addedKeys.add(key2);
            }
            addedItems.put("parameters", addedKeys);
        }
        if ((pathsToAdd = incomingDoc.getPaths()) != null && !pathsToAdd.isEmpty()) {
            itr = pathsToAdd.keySet().iterator();
            HashSet<String> addedKeys = new HashSet<String>();
            while (itr.hasNext()) {
                key2 = itr.next();
                this.path(key2, pathsToAdd.get(key2));
                addedKeys.add(key2);
            }
            vExtensions = incomingDoc.getPathsObject().getVendorExtensions();
            if (vExtensions != null && !vExtensions.isEmpty()) {
                for (String key2 : vExtensions.keySet()) {
                    this.paths.setVendorExtension(key2, vExtensions.get(key2));
                    addedKeys.add(key2);
                }
            }
            addedItems.put("paths", addedKeys);
        }
        if ((secToAdd = incomingDoc.getSecurityDefinitions()) != null && !secToAdd.isEmpty()) {
            itr = secToAdd.keySet().iterator();
            HashSet<String> addedKeys = new HashSet<String>();
            while (itr.hasNext()) {
                key2 = itr.next();
                this.addSecurityDefinition(key2, secToAdd.get(key2));
                addedKeys.add(key2);
            }
            addedItems.put("securityDefinitions", addedKeys);
        }
        if ((respToAdd = incomingDoc.getResponses()) != null && !respToAdd.isEmpty()) {
            itr = respToAdd.keySet().iterator();
            HashSet<String> addedKeys = new HashSet<String>();
            while (itr.hasNext()) {
                key2 = itr.next();
                this.addResponse(key2, respToAdd.get(key2));
                addedKeys.add(key2);
            }
            addedItems.put("responses", addedKeys);
        }
        if ((tagsToAdd = incomingDoc.getTags()) != null && !tagsToAdd.isEmpty()) {
            HashSet<String> addedTags = new HashSet<String>();
            for (Tag aTag : tagsToAdd) {
                if (aTag == null) continue;
                this.addTag(aTag);
                addedTags.add(aTag.getName());
            }
            if (!addedTags.isEmpty()) {
                addedItems.put("tags", addedTags);
            }
        }
        return addedItems;
    }

    public void addItems(Swagger swgSource, Map<String, Set<String>> itemsToAdd) {
        if (swgSource == null || itemsToAdd == null || itemsToAdd.isEmpty()) {
            return;
        }
        for (String fieldName : itemsToAdd.keySet()) {
            this.addItemsFromSwagger(swgSource, fieldName, itemsToAdd.get(fieldName));
        }
    }

    private void addItemsFromSwagger(Swagger swgSource, String fieldName, Set<String> toAdd) {
        if (swgSource == null || fieldName == null || fieldName.isEmpty() || toAdd == null || toAdd.isEmpty()) {
            return;
        }
        block0: for (String name : toAdd) {
            if (name == null || name.isEmpty()) continue;
            if ("definitions".equals(fieldName)) {
                if (swgSource.getDefinitions() == null || swgSource.getDefinitions().get(name) == null) continue;
                this.addDefinition(name, swgSource.getDefinitions().get(name));
                continue;
            }
            if ("parameters".equals(fieldName)) {
                if (swgSource.getParameter(name) == null) continue;
                this.addParameter(name, swgSource.getParameter(name));
                continue;
            }
            if ("paths".equals(fieldName)) {
                if (swgSource.getPath(name) == null) continue;
                this.path(name, swgSource.getPath(name));
                continue;
            }
            if ("securityDefinitions".equals(fieldName)) {
                if (swgSource.getSecurityDefinitions() == null || swgSource.getSecurityDefinitions().get(name) == null) continue;
                this.addSecurityDefinition(name, swgSource.getSecurityDefinitions().get(name));
                continue;
            }
            if ("responses".equals(fieldName)) {
                if (swgSource.getResponse(name) == null) continue;
                this.addResponse(name, swgSource.getResponse(name));
                continue;
            }
            if (!"tags".equals(fieldName) || swgSource.getTags() == null) continue;
            for (Tag aTag : swgSource.getTags()) {
                if (aTag == null || !name.equals(aTag.getName())) continue;
                this.addTag(aTag);
                continue block0;
            }
        }
    }

    public void removeItems(Map<String, Set<String>> removeItems) {
        if (removeItems == null || removeItems.isEmpty()) {
            return;
        }
        for (String fieldName : removeItems.keySet()) {
            this.removeItemsFromSwaggerField(fieldName, removeItems.get(fieldName));
        }
    }

    private void removeItemsFromSwaggerField(String fieldName, Set<String> toRemove) {
        if (fieldName == null || fieldName.isEmpty() || toRemove == null || toRemove.isEmpty()) {
            return;
        }
        block0: for (String name : toRemove) {
            if (name == null || name.isEmpty()) continue;
            if ("definitions".equals(fieldName)) {
                if (this.definitions == null) continue;
                this.definitions.remove(name);
                continue;
            }
            if ("parameters".equals(fieldName)) {
                if (this.parameters == null) continue;
                this.parameters.remove(name);
                continue;
            }
            if ("paths".equals(fieldName)) {
                if (this.paths == null) continue;
                if (name.startsWith("x-")) {
                    this.paths.getVendorExtensions().remove(name);
                    continue;
                }
                this.paths.getPaths().remove(name);
                continue;
            }
            if ("securityDefinitions".equals(fieldName)) {
                if (this.securityDefinitions == null) continue;
                this.securityDefinitions.remove(name);
                continue;
            }
            if ("responses".equals(fieldName)) {
                if (this.responses == null) continue;
                this.responses.getResponses().remove(name);
                continue;
            }
            if ("tags".equals(fieldName)) {
                if (this.tags == null) continue;
                for (Tag aTag : this.tags) {
                    if (aTag == null || !name.equals(aTag.getName())) continue;
                    this.tags.remove(aTag);
                    continue block0;
                }
                continue;
            }
            if (!"swvendorext".equals(fieldName) || this.vendorExtensions == null) continue;
            this.vendorExtensions.remove(name);
        }
    }

    private void validateBasePath() {
        if (this.basePath == null) {
            return;
        }
        if (!this.basePath.startsWith("/") || this.basePath.contains("{") || this.basePath.contains("}")) {
            throw new SwaggerException(Tr.formatMessage((TraceComponent)tc, (String)"INVALID_VALUE", (Object[])new Object[]{"basePath", this.basePath}));
        }
    }

    private void validateHost() {
        if (this.host == null) {
            return;
        }
        String hostValue = this.host.trim();
        if (hostValue.startsWith("http:") || hostValue.startsWith("https:") || hostValue.startsWith("ws:") || hostValue.startsWith("wss:") || hostValue.contains("/") || hostValue.contains("{") || hostValue.contains("}")) {
            throw new SwaggerException(Tr.formatMessage((TraceComponent)tc, (String)"INVALID_VALUE", (Object[])new Object[]{"host", this.host}));
        }
    }

    private void validatePaths() {
        if (this.paths != null && !this.paths.getPaths().isEmpty()) {
            for (String pathName : this.paths.getPaths().keySet()) {
                if (pathName != null && !pathName.trim().isEmpty() && pathName.startsWith("/")) continue;
                throw new SwaggerException(Tr.formatMessage((TraceComponent)tc, (String)"INVALID_VALUE", (Object[])new Object[]{"path", pathName}));
            }
        }
    }

    private void validateGlobalSecurity() {
        if (this.security != null) {
            for (SecurityRequirement sr : this.security) {
                if (sr.getRequirements() == null) continue;
                for (String s : sr.getRequirements().keySet()) {
                    if (this.securityDefinitions != null && this.securityDefinitions.containsKey(s)) continue;
                    throw new SwaggerException(Tr.formatMessage((TraceComponent)tc, (String)"INVALID_SECURITY_DEFINITION", (Object[])new Object[]{s}));
                }
            }
        }
    }

    private void validateOperations() {
        if (this.paths != null && !this.paths.getPaths().isEmpty()) {
            HashSet<String> operationIDs = new HashSet<String>();
            for (String pathName : this.paths.getPaths().keySet()) {
                Path aPath = this.paths.getPath(pathName);
                if (aPath == null || aPath.getOperations() == null) continue;
                for (Operation operation : aPath.getOperations()) {
                    if (operation == null) continue;
                    String operationId = operation.getOperationId();
                    if (operationId != null && !operationIDs.add(operationId)) {
                        throw new SwaggerException(Tr.formatMessage((TraceComponent)tc, (String)"INVALID_OPERATION_ID", (Object[])new Object[]{operationId}));
                    }
                    this.validateSchemes(operation.getSchemes());
                }
            }
        }
    }

    private void validateGlobalSchemes() {
        this.validateSchemes(this.schemes);
    }

    private void validateSchemes(List<Scheme> schemes) {
        if (schemes != null) {
            for (Scheme scheme : schemes) {
                if (scheme != null && scheme.toValue() != null && !scheme.toValue().isEmpty() && !scheme.toValue().equalsIgnoreCase("null")) continue;
                throw new SwaggerException(Tr.formatMessage((TraceComponent)tc, (String)"INVALID_VALUE", (Object[])new Object[]{"schemes", schemes}));
            }
        }
    }

    public void validate() {
        this.validateBasePath();
        this.validateHost();
        this.validatePaths();
        this.validateGlobalSecurity();
        this.validateGlobalSchemes();
        this.validateOperations();
    }

    public Set<String> gatherTagNames() {
        HashSet<String> tagNames = new HashSet<String>();
        if (this.tags == null || this.tags.isEmpty()) {
            return tagNames;
        }
        for (Tag tag : this.tags) {
            if (tag == null || tag.getName() == null || tag.getName().isEmpty()) continue;
            tagNames.add(tag.getName());
        }
        return tagNames;
    }

    public void overrideTags(String tagName) {
        Tag aTag = new Tag();
        aTag.setName(tagName);
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        tagList.add(aTag);
        this.setTags(tagList);
        if (this.paths != null && !this.paths.getPaths().isEmpty()) {
            for (String pathName : this.paths.getPaths().keySet()) {
                Path aPath = this.paths.getPath(pathName);
                if (aPath == null || aPath.getOperations() == null) continue;
                for (Operation operation : aPath.getOperations()) {
                    if (operation == null) continue;
                    ArrayList<String> tagNames = new ArrayList<String>();
                    tagNames.add(tagName);
                    operation.setTags(tagNames);
                }
            }
        }
    }

    public void modifyPaths() {
        String baseValue;
        String hostValue = this.host == null || this.host.isEmpty() ? "" : "/" + this.host;
        String string = baseValue = this.basePath == null || this.basePath.equals("/") ? "" : this.basePath;
        if (baseValue.endsWith("/")) {
            baseValue = baseValue.substring(0, baseValue.length() - 1);
        }
        if (hostValue.isEmpty() && baseValue.isEmpty()) {
            return;
        }
        if (this.paths != null && !this.paths.getPaths().isEmpty()) {
            HashSet<String> pathsToModify = new HashSet<String>();
            for (String path : this.paths.getPaths().keySet()) {
                if ("/".equals(path)) {
                    pathsToModify.add(path);
                    continue;
                }
                String[] splittedPath = path.split("/");
                if (splittedPath.length != 2 && (splittedPath.length <= 1 || splittedPath[1].contains(":"))) continue;
                pathsToModify.add(path);
            }
            String httpPort = String.valueOf(this.vendorExtensions.get("x-ibm-httpPort"));
            String httpsPort = String.valueOf(this.vendorExtensions.get("x-ibm-httpsPort"));
            boolean hasHttpPort = !httpPort.isEmpty() && !httpPort.equalsIgnoreCase("null") && !httpPort.equals("0") && !httpPort.equals("-1");
            boolean hasHttpsPort = !httpsPort.isEmpty() && !httpsPort.equalsIgnoreCase("null") && !httpsPort.equals("0") && !httpsPort.equals("-1");
            String hostDomainValue = hostValue.contains(":") ? hostValue.substring(0, hostValue.indexOf(":")) : "";
            boolean isCollectiveMembersDoc = (hasHttpPort || hasHttpsPort) && !hostDomainValue.isEmpty();
            for (String path : pathsToModify) {
                Path aPath = this.paths.getPaths().remove(path);
                String newHostValue = hostValue;
                if (isCollectiveMembersDoc) {
                    if (hasHttpsPort && !this.isSchemeSupported(aPath, Scheme.HTTP) && this.isSchemeSupported(aPath, Scheme.HTTPS)) {
                        this.overrideSchemes(aPath, Scheme.HTTPS);
                        newHostValue = hostDomainValue + ":" + httpsPort;
                    } else if (hasHttpPort) {
                        this.overrideSchemes(aPath, Scheme.HTTP);
                        newHostValue = hostDomainValue + ":" + httpPort;
                    }
                }
                this.paths.setPath(newHostValue + baseValue + path, aPath);
            }
        }
    }

    private void overrideSchemes(Path aPath, Scheme scheme) {
        if (aPath != null && scheme != null) {
            ArrayList<Scheme> overrideValue = new ArrayList<Scheme>();
            overrideValue.add(scheme);
            for (Operation op : aPath.getOperations()) {
                op.setSchemes(overrideValue);
            }
        }
    }

    private boolean isSchemeSupported(Path aPath, Scheme scheme) {
        if (aPath != null && scheme != null) {
            for (Operation op : aPath.getOperations()) {
                List<Scheme> schemes = op.getSchemes();
                if (schemes == null || !schemes.contains((Object)scheme)) continue;
                return true;
            }
        }
        return false;
    }
}

